<?php

namespace App\Models\Challenges;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChallengeElement extends Model 
{

    protected $table = 'challenge_elements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getChallenge()
    {
        return $this->belongsTo('App\Models\Challenges\Challenge');
    }

    public function getQuiz()
    {
        return $this->belongsTo('App\Models\Quizes\Quiz');
    }

    public function getEventRealization()
    {
        return $this->belongsTo('App\Models\Events\EventRealization');
    }

    public function getActivity()
    {
        return $this->belongsTo('App\Models\Activities\Activity');
    }

}